//
//  B5ItemProperties.h
//  ApplicationFrameworks
//
//  Created by Rick Fillion on 2015-05-13.
//
//

#import <Foundation/Foundation.h>

@interface B5ItemProperties : NSObject <NSSecureCoding>

@property (nonatomic, assign, readonly) NSUInteger itemVersion;
@property (nonatomic, assign, readonly) NSUInteger localEditCount;
@property (nonatomic, assign) NSUInteger rejectedBuildVersion;
@property (nonatomic, strong) NSString *rejectionReason;

@property (nonatomic, readonly) NSString *changerUUID;

@end

// Methods that only the B5Databse should call
@interface B5ItemProperties (B5DatabaseAndSyncOnly)

- (void)_setItemVersion:(NSUInteger)itemVersion;
- (void)_setLocalEditCount:(NSUInteger)localEditCount;
- (void)_setChangerUUID:(NSString *)uuid;

@end
